<?php 

class Connection
{
	static public function connect()
	{
		try
		{
			$link = new PDO("mysql:host=localhost;dbname=grupomd_monitoreo","grupomd_monitoreo","E+qbpT2?B8");
			
			$link->exec("set names utf8");
			$link->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

            return $link;
		}
		catch(PDOExecption $e)
		{
			die("El error de conexion es: " . $e->getMessage());
		}
		
		return $link;
	}
}

function getLogo($_nombre_equipo)
{
    switch ($_nombre_equipo) {
        case 'Técnico Univ.':
        $logo = "tec.gif";
        break;
        case 'Ind. del Valle':
        $logo = "idv.gif";
        break;
        case 'El Nacional':
        $logo = "nac.gif";
        break;
        case 'D. Cuenca':
        $logo = "cue.gif";
        break;
        case 'Emelec':
        $logo = "cse.gif";
        break;
        case 'Gualaceo':
        $logo = "gua.gif";
        break;
        case 'Orense':
        $logo = "ore.gif";
        break;
        case 'Cumbayá FC':
        $logo = "cum.gif";
        break;
        case 'Delfín':
        $logo = "del.gif";
        break;
        case 'Guayaquil City':
        $logo = "city.gif";
        break;
        case 'Barcelona':
        $logo = "bsc.gif";
        break;
        case 'Mushuc Runa':
        $logo = "mrn.gif";
        break;
        case 'LDU Quito':
        $logo = "liga.gif";
        break;
        case 'Aucas':
        $logo = "auc.gif";
        break;
        case 'Libertad FC':
        $logo = "lib.gif";
        break;
         case 'U.Católica':
        $logo = "cat.gif";
        break;
    }
    return $logo;
}
?>  
<!doctype html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="">
    <meta name="generator" content="">
    <meta name="robots" content="noindex,nofollow" />
    <title>Tabla de Posiciones Liga Pro </title>
    <link rel="canonical" href="">
    <!-- Bootstrap core CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/2.2.4/jquery.min.js"></script>
    <!-- Custom styles for this template -->
    <link href="./css/style.css" rel="stylesheet">
    <style>
        .nav-tabs .nav-item.show .nav-link, .nav-tabs .nav-link.active {
        color: #495057;
        background-color: #e6e6e6;
        font-weight: 700;
        border-color: #dee2e6 #dee2e6 #fff;
    }
    </style>
</head>
<body>
    <div class="container" style="max-width: 100%;padding-left:0px;padding-right:0px">
      <main style="">
        <div class="">
          <!-- Nav tabs -->
          <ul class="nav nav-tabs">
            <li class="nav-item ">
              <a class="nav-link" data-bs-toggle="tab" href="#etapa1" style="color:#212529">Fase 1</a>
            </li>
            <li class="nav-item ">
              <a class="nav-link active" data-bs-toggle="tab" href="#etapa2" style="color:#212529">Fase 2</a>
            </li>
            <li class="nav-item">
              <a class="nav-link" data-bs-toggle="tab" href="#acum" style="color:#212529">Acumulada</a>
            </li>
          </ul>
          <!-- Tab panes -->
          <div class="tab-content" style="width:100%">
            <div class="tab-pane container" id="etapa1">
              <table class="table mt-2" width="100%">
                <thead>
                  <tr style="background-color: #e6e6e6;font-weight: 700">
                    <td class="text-center">#</td>
                    <td>EQUIPO</td>
                    <td class="text-center">PTS</td>
                    <td class="text-center">PJ</td>
                    <td class="text-center">GD</td>
                  </tr>
                </thead>
                <tbody id="TableData-1">
                    <?php 
                    $stmt = Connection::connect()->prepare("SELECT * FROM tbl_tabla_posiciones WHERE fase='etapa1' ORDER BY posicion");
                    $stmt -> execute();
                    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
                    $_num_rows = $stmt->rowCount();
                    if ($_num_rows>0)
            		{
            		    foreach($rows as $row)
                        {
                            ?>
                		    <tr>
                				<td class="text-center" width="5" style="font-weight: 700;padding: 2px 2px">
                					<?php echo $row['posicion'] ?>
                				</td>
                				<td style="padding: 2px 2px">
                					<img height='25' width="25" src="https://grupomakrodigital.com/ligapro/images/<?php echo getLogo($row['equipo']) ?>">
                					<?php echo $row['equipo'] ?>
                				</td>
                				<td class="text-center" style="font-weight: 700;padding: 2px 2px"><?php echo $row['puntos'] ?></td>
                				<td class="text-center" style="padding: 2px 2px"><?php echo $row['pj'] ?></td>
                				<td class="text-center" style="padding: 2px 2px"><?php echo $row['gd'] ?></td>
                			</tr>
                		    <?php   
                        }
            		}
                    ?>
                    <tr><td colspan="5" class="text-center" style="font-weight: 700;padding: 2px 2px;background-color: #e6e6e6;">Powered by MakroDigital</td></tr>
                </tbody>
              </table>
            </div>
            <div class="tab-pane container active" id="etapa2">
              <table class="table mt-2" width="100%">
                <thead>
                  <tr style="background-color: #e6e6e6;font-weight: 700">
                    <td class="text-center">#</td>
                    <td>EQUIPO</td>
                    <td class="text-center">PTS</td>
                    <td class="text-center">PJ</td>
                    <td class="text-center">GD</td>
                  </tr>
                </thead>
                <tbody id="TableData-2">
                    <?php 
                    $stmt = Connection::connect()->prepare("SELECT * FROM tbl_tabla_posiciones WHERE fase='etapa2' ORDER BY posicion");
                    $stmt -> execute();
                    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
                    $_num_rows = $stmt->rowCount();
                    if ($_num_rows>0)
            		{
            		    foreach($rows as $row)
                        {
                            ?>
                		    <tr>
                				<td class="text-center" width="5" style="font-weight: 700;padding: 2px 2px">
                					<?php echo $row['posicion'] ?>
                				</td>
                				<td style="padding: 2px 2px">
                					<img height='25' width="25" src="https://grupomakrodigital.com/ligapro/images/<?php echo getLogo($row['equipo']) ?>">
                					<?php echo $row['equipo'] ?>
                				</td>
                				<td class="text-center" style="font-weight: 700;padding: 2px 2px"><?php echo $row['puntos'] ?></td>
                				<td class="text-center" style="padding: 2px 2px"><?php echo $row['pj'] ?></td>
                				<td class="text-center" style="padding: 2px 2px"><?php echo $row['gd'] ?></td>
                			</tr>
                		    <?php   
                        }
            		}
                    ?>
                </tbody>
              </table>
            </div>
            <div class="tab-pane container fade" id="acum">
              <table class="table mt-2" width="100%">
                <thead>
                  <tr style="background-color: #e6e6e6;font-weight: 700">
                    <td class="text-center">#</td>
                    <td>EQUIPO</td>
                    <td class="text-center">PTS</td>
                    <td class="text-center">PJ</td>
                    <td class="text-center">GD</td>
                  </tr>
                </thead>
                <tbody id="TableData-acum"></tbody>
              </table>
            </div>
          </div>
        </div>
      </main>
    </div>
    <script>
    function getData() {
        const data = {
            token: window.location.host,
        };
        (async () => {
            const rawResponse = await fetch('https://grupomakrodigital.com/ligapro/api/', {
                method: 'POST',
                body: JSON.stringify(data)
            });
            const content = await rawResponse.json();  
            
            if(content.etapa_actual == 1)
            {
                $.each(content.etapa1, function(key, data) {
                    createTable(sortTable(content.etapa1),1)
                });
            }else
            {
                $.each(content.etapa2, function(key, data) {
                    createTable(sortTable(content.etapa2),2)
                });
            }

        })();

    }
    function CreateEtapa1(){
        const data = {
            token: window.location.host,
        };
        (async () => {
            const rawResponse = await fetch('https://grupomakrodigital.com/ligapro/api/', {
                method: 'POST',
                body: JSON.stringify(data)
            });
            const content = await rawResponse.json();  
            
            $.each(content.etapa1, function(key, data) {
                    createTable(sortTable(content.etapa1),1)
            });

        })();
    }
    function CreateEtapa2(){
        const data = {
            token: window.location.host,
        };
        (async () => {
            const rawResponse = await fetch('https://grupomakrodigital.com/ligapro/api/', {
                method: 'POST',
                body: JSON.stringify(data)
            });
            const content = await rawResponse.json();  
            
            $.each(content.etapa2, function(key, data) {
                    createTable(sortTable(content.etapa2),2)
            });

        })();
    }
    function CreateAcum(){
        const data = {
            token: window.location.host,
        };
        (async () => {
            const rawResponse = await fetch('https://grupomakrodigital.com/ligapro/api/', {
                method: 'POST',
                body: JSON.stringify(data)
            });
            const content = await rawResponse.json();  
            
            $.each(content.acumulada, function(key, data) {
                    createTable(sortTable(content.acumulada),'acum')
            });

        })();
    }
    function sortTable(data){
    	const list = data.sort(function (a, b) {
    		let apts = a.PTS
    		let bpts = b.PTS
    
    		let agd = a.GD
    		let bgd = b.GD
    
    		let agf = a.GF
    		let bgf = b.GF
    
    		let agc = a.GC;
    		let bgc = b.GC
    
    		if(apts == bpts){
    			if(agd > bgd) {
    				return -1
    			} else if(agd < bgd) {
    				return 1
    			} else if(agd == bgd){
    				if(agf > bgf) return -1
    				else if(agf < bgf) return 1
    				else if(agc < bgc) return -1
    				else if(agc > bgc) return 1
    				else return 1
    			}
    		} else if(apts > bpts) {
    			return -1
    		} else return 1
    	}).map(function(data, index, array){
    		return data
    	});
    	return list
    	//console.log(list);
    }
    function createTable(data,_etapa) 
    {
        let cont=1;
        let table = '';
        $.each(data, function(key, data) 
        {
            table += `
			<tr>
				<td class="text-center" width="5" style="font-weight: 700;padding: 2px 2px">
					${cont}
				</td>
				<td style="padding: 2px 2px">
					<img height='20' width="20" src="https://grupomakrodigital.com/ligapro/${data.LOGO}">
					${data.NOMBRE}
				</td>
				<td class="text-center" style="font-weight: 700;padding: 2px 2px">${data.PTS}</td>
				<td class="text-center" style="padding: 2px 2px">${data.PJ}</td>
				<td class="text-center" style="padding: 2px 2px">${data.GD}</td>
			</tr>
			`
		    cont++    
        })
        table +=` <tr><td colspan="5" class="text-center" style="font-weight: 700;padding: 2px 2px;background-color: #e6e6e6;">Powered by MakroDigital</td></tr>`
		$("#TableData-"+_etapa).html(table);
    }
    </script>
</body>
</html>